/************************************************************************
 * NAME:	marshaling
 *
 * DESCR:	Routines to read/write the given data structures to/from
 *		the disk image.
 *
 * NOTES:	
 ************************************************************************/
#include "ados.h"
#include "standard.h"
#include "init.h"

/************************************************************************
 * NAME:	int_read() & int_write()
 *
 * DESCR:	Using the LO/HI method for writing integer values, reads
 *		and writes them to the image.
 *
 * NOTES:	
 ************************************************************************/
int
int_read(unsigned char *buffer)
{
    int	r = 0;

    r = *buffer++;
    r |= (*buffer << 8) & 0xff00;

    return(r);
}

int
int_write(int target, unsigned char *buffer)
{
    *buffer++ = target & 0x00ff;
    *buffer   = (target >> 8) & 0x00ff;

    return(target);
}
